--Initial campaign triggers (static file, not updated)
--Copied to Status/camp_triggers.lua in first mission and subsequently read and updated there
--Campaign triggers are defined with conditions and actions
-------------------------------------------------------------------------------------------------------

--List of Return functions to build conditions:
--Return.Time()							returns time of day in seconds
--Return.Day()							returns day of month
--Return.Month()						returns month as number
--Return.Year()							returns year as number
--Return.Mission()						returns campaign mission number
--Return.CampFlag(flag-n)				returns value of campaign flag
--Return.AirUnitActive("UnitName")		returned boolean whether the air unit is active			
--Return.AirUnitReady("UnitName")		returns amount of ready aircraft in unit
--Return.AirUnitAlive("UnitName")		returns amount of ready and damaged aircraft in unit
--Return.AirUnitBase("UnitName")		returns the name of the airbase the unit operats from
--Return.AirUnitPlayer("UnitName")		returns boolean whether the air units is playable
--Return.TargetAlive("TargetName")		returns percentage of alive sub elements in target
--Return.GroupHidden("GroupName")		returns group hidden status
--Return.GroupProbability("GroupName")	returns group spawn probability value between 0 and 1

--List of Action functions for trigger actions:
--Action.None()
--Action.Text("your briefing text")
--Action.SetCampFlag(flag-n, boolean/number)
--Action.AddCampFlag(flag-n, number)
--Action.AddImage("filname.jpg")
--Action.CampaignEnd("win"/"draw"/"loss")
--Action.TargetActive("TargetName", boolean)
--Action.AirUnitActive("UnitName", boolean)
--Action.AirUnitBase("UnitName", "BaseName")
--Action.AirUnitPlayer("UnitName", boolean)
--Action.AirUnitReinforce("SourceUnitName", "DestinationUnitName", destNumber)
--Action.AirUnitRepair()
--Action.AddGroundTargetIntel("sideName")
--Action.GroupHidden("GroupName", boolean)
--Action.GroupProbability("GroupName", number 0-1)

--Important notes:
--for condition and action strings: outside with single quotes '', inside with double quotes ""!

camp_triggers = {
	
	----- CAMPAIGN INTRO ----
	["Campaign Briefing"] = {										--Trigger name
		active = true,												--Trigger is active
		once = true,												--Trigger is fired once
		condition = 'true',											--Condition of the trigger to return true or false embedded as string
		action = {													--Trigger action function embedded as string
			[1] = 'Action.Text("It is 1987 and the we are still in a struggle to control Afghanistan.  Refugees are fleeing across the border into Pakistan.  Where U.N. forces have setup refugee camps.")',
			[2] = 'Action.Text("We have started bombing these refugee camps within the Pakistani borders.  We also employed the services of our new Flankers and Fulcrums.  The United States have provided Air and Anti-Air assets to aid Pakistan in protecting the refugee camps. As well as aid the refugees still fleeing.")',
			[3] = 'Action.Text("We need to stop those refugees by any means neccessary.  And destroy the Pakistani forces who dare interfere.")',
		},
	},	
	
	----- CAMPAIGN END -----
	["Campaign End Victory"] = {
		active = true,
		once = true,
		condition = 'GroundTarget["red"].percent < 14',
		action = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("With the destruction of majority of the Soviet Forces.  The Remaining troops are withdrawing from Afghanistan.")',
		},
	},
	["Campaign End Loss"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("187th Assault Aviation Regiment") + Return.AirUnitAlive("R/187th Assault Aviation Regiment") < 4',
		action = {
			[1] = 'Action.CampaignEnd("loss")',
			[2] = 'Action.Text("We have lost too many aircraft supplied by the United States.  We can no longer keep up with the air war.")',
		},
	},
	["Campaign End Draw"] = {
		active = true,
		once = true,
		condition = 'MissionInstance == 50',
		action = {
			[1] = 'Action.CampaignEnd("draw")',
			[2] = 'Action.Text("The Soviets can not get past our defenses.  But we also could not get past theirs.  It seems we have come to a stalemate.")',
		},
	},
	
	
	----- UNIT ACTIVATION -----
	
	----- REPAIR AND REINFORCEMENTS -----
	["Repair"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitRepair()',
	},
	["Reinforcemenets No. 5 Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R-No.5", "No. 5 Squadron", 10)',
	},
	["Reinforcemenets No. 11 Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R-No.11", "No. 11 Squadron", 8)',
	},
	["Reinforcemenets No. 9 Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R-No.9", "No. 9 Squadron", 6)',
	},	
	["Reinforcemenets No. 10 Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R-No.9", "No. 10 Squadron", 4)',
	},
	["Reinforcemenets No. 25 Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R-No.25", "No. 25 Squadron", 8)',
	},
	["Reinforcemenets No. 28 Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R-UH-1H", "No. 28 Squadron", 4)',
	},
	["Reinforcemenets No. 29 Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R-UH-1H", "No. 29 Squadron", 4)',
	},
	["Reinforcemenets No. 27 Squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R-SA342M", "No. 27 Squadron", 4)',
	},
	["Reinforcemenets 177th Fighter Aviation Regiment"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/177th Fighter Aviation Regiment", "177th Fighter Aviation Regiment", 6)',
	},
	["Reinforcemenets 33rd Fighter Aviation Regiment"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/33rd Fighter Aviation Regiment", "33rd Fighter Aviation Regiment", 10)',
	},
	["Reinforcemenets 187th Assault Aviation Regiment"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/187th Assault Aviation Regiment", "187th Assault Aviation Regiment", 6)',
	},
	["Reinforcemenets 458th Fighter Aviation Regiment"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/458th Fighter Aviation Regiment", "458th Fighter Aviation Regiment", 8)',
	},
	["Reinforcemenets 202nd fixed-wing squadron"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/202nd fixed-wing squadron", "202nd fixed-wing squadron", 8)',
	},
	["Reinforcemenets 559th Bomber Aviation Regiment"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/559th Bomber Aviation Regiment", "559th Bomber Aviation Regiment", 8)',
	},
	["Reinforcemenets 45th Independent Helicopter Regiment"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/45th Independent Helicopter Regiment", "45th Independent Helicopter Regiment", 4)',
	},
	["Reinforcemenets 361st Independent Helicopter Regiment"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/361st Independent Helicopter Regiment", "361st Independent Helicopter Regiment", 4)',
	},
	["Reinforcemenets 793rd Independent Helicopter Regiment"] = {
		active = true,
		condition = 'true',
		action = 'Action.AirUnitReinforce("R/793rd Independent Helicopter Regiment", "793rd Independent Helicopter Regiment", 4)',
	},
	
	
	----- AVIATION UNIT STATUS -----
	["187th Assault Aviation Regiment 75%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("187th Assault Aviation Regiment") + Return.AirUnitAlive("R/187th Assault Aviation Regiment") < 24',
		action = 'Action.Text("Aircraft strength of the 187th Assault Aviation Regiment, has fallen below 75%.")',
	},
	["187th Assault Aviation Regiment 50%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("187th Assault Aviation Regiment") + Return.AirUnitAlive("R/187th Assault Aviation Regiment") < 16',
		action = 'Action.Text("Aircraft strength of the 187th Assault Aviation Regiment, has fallen below 50%. If losses continue at the present rate, the combat capability of the Unit is in jeopardy.")',
	},
	["187th Assault Aviation Regiment 25%"] = {
		active = true,
		once = true,
		condition = 'Return.AirUnitAlive("187th Assault Aviation Regiment") + Return.AirUnitAlive("R/187th Assault Aviation Regiment") < 8',
		action = 'Action.Text("Aircraft strength of the 187th Assault Aviation Regiment, has fallen below 25%. The number of available airframes is critically low. The Unit is short of losing all remaining combat capacity.")',
	},

	
	
	---- GROUND TARGET STATUS ---
	["Blue Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("blue")',
	},
	["Red Ground Target Briefing Intel"] = {
		active = true,
		condition = 'true',
		action = 'Action.AddGroundTargetIntel("red")',
	},
	
	
	----- AIRBASE STRIKES -----
	["North Airfield Logistics and FARP Lincoln Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("North Airfield Logistics and FARP Lincoln") == 0',
		action = {
			[1] = 'db_airbases["Lincoln"].inactive = true',
			[2] = 'db_airbases["FARP Lincoln"].inactive = true',
		}
	},
	["North Airfield Logistics and FARP Lincoln Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("North Airfield Logistics and FARP Lincoln") == 0',
		action = {
			[1] = 'Action.Text("After the facilities at North Airfield Logistics and FARP Lincoln have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		}
	},
	["South Airfield Logistics Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("South Airfield Logistics") == 0',
		action = {
			[1] = 'db_airbases["Nellis AFB"].inactive = true',
		}
	},
	["South Airfield Logistics Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("South Airfield Logistics") == 0',
		action = {
			[1] = 'Action.Text("The infrastructure at South Airfield Logistics has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume.")',
		}
	},
	["East Airfield Logistics Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("East Airfield Logistics") == 0',
		action = {
			[1] = 'db_airbases["Mesquite"].inactive = true',
		}
	},
	["East Airfield Logistics Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("East Airfield Logistics") == 0',
		action = {
			[1] = 'Action.Text("The infrastructure at East Airfield Logistics has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume. ")',
		}
	},
	["FARP Sandy Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("FARP Sandy") == 0',
		action = {
			[1] = 'db_airbases["FARP Sandy"].inactive = true',
		}
	},
	["FARP Sandy Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("FARP Sandy") == 0',
		action = {
			[1] = 'Action.Text("The infrastructure at FARP Sandy has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume. ")',
		}
	},
	["FARP Hilly Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("FARP Hilly") == 0',
		action = {
			[1] = 'db_airbases["FARP Hilly"].inactive = true',
		}
	},
	["FARP Hilly Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("FARP Hilly") == 0',
		action = {
			[1] = 'Action.Text("The infrastructure at FARP Hilly has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume. ")',
		}
	},
	["South Airbase Logistics Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("South Airbase Logistics") == 0',
		action = {
			[1] = 'db_airbases["Creech AFB"].inactive = true',
		}
	},
	["South Airbase Logistics Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("South Airbase Logistics") == 0',
		action = {
			[1] = 'Action.Text("After the facilities at South Airbase Logistics have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		}
	},
	["Central Airbase Logistics Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("Central Airbase Logistics") == 0',
		action = {
			[1] = 'db_airbases["Groom Lake AFB"].inactive = true',
		}
	},
	["Central Airbase Logistics Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Central Airbase Logistics") == 0',
		action = {
			[1] = 'Action.Text("The infrastructure at Central Airbase Logistics has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume.")',
		}
	},
	["North West Airbase Logistics Disabled"] = {
		active = true,
		condition = 'Return.TargetAlive("North West Airbase Logistics") == 0',
		action = {
			[1] = 'db_airbases["Tonopah AFB"].inactive = true',
		}
	},
	["North West Airbase Logistics Disabled Text"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("North West Airbase Logistics") == 0',
		action = {
			[1] = 'Action.Text("The infrastructure at North West Airbase Logistics has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume. ")',
		}
	},
	["Bomber Airbase Logistics"] = {
		active = true,
		condition = 'Return.TargetAlive("Bomber Airbase Logistics") == 0',
		action = {
			[1] = 'db_airbases["Tonopah Airport"].inactive = true',
		}
	},
	["Bomber Airbase Logistics"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Bomber Airbase Logistics") == 0',
		action = {
			[1] = 'Action.Text("The infrastructure at Bomber Airbase Logistics has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume. ")',
		}
	},
	["Northern FARP"] = {
		active = true,
		condition = 'Return.TargetAlive("Northern FARP") == 0',
		action = {
			[1] = 'db_airbases["FARP Skala"].inactive = true',
			[2] = 'db_airbases["FARP Vetka"].inactive = true',
		}
	},
	["Northern FARP"] = {
		active = true,
		once = true,
		condition = 'Return.TargetAlive("Northern FARP") == 0',
		action = {
			[1] = 'Action.Text("The infrastructure at Northern FARP has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume. ")',
		}
	},
	
	
	

	
}